<?php

class AopsMailchimpIntegration extends Aops {

	private static $options = array();

	public static $apiKey = '';

	public function __construct() {
		self::$options = self::getOptions();
		self::$apiKey = self::$options['mailchimp_api_key'];

		/* Check Mailchimp API key when it`s entered */
		add_action( 'admin_init', array( $this, 'checkMailchimpApiKey' ) );

		/* Check Mailchimp extra List ID when it`s entered */
		add_action( 'admin_init', array( $this, 'checkMailchimpList' ) );

	}

	public function checkMailchimpApiKey() {
		if (isset($_POST['aops_cu_mailchimp_api_key'])) {
			$newApiKey = $_POST['aops_cu_mailchimp_api_key'];
			if ($newApiKey != '') {
				self::log("checkMailchimpApiKey: " . $newApiKey);
				// Check is response indicates successful connect to Mailchimp
				if (is_array(self::getMailchimpLists($newApiKey))) {
					$newMailchimpStatus = self::STATUS_OK;
				}
				else {
					$newMailchimpStatus = self::STATUS_FAIL;
				}

				self::log("checkMailchimpApiKey newMailchimpStatus " . $newMailchimpStatus);
				// clear options cache
				wp_cache_delete ( 'alloptions', 'options' );
			}
			else{
				$newMailchimpStatus = self::STATUS_UNKNOWN;
			}

			// wordpress will use this later to save option into DB
			$_POST['aops_cu_mailchimp_status'] = $newMailchimpStatus;
		}
	}


	// Check if user entered correct List ID
	public function checkMailchimpList() {
		if (isset($_POST['aops_cu_mailchimp_default_extra_list_id'])) {
			$listId = $_POST['aops_cu_mailchimp_default_extra_list_id'];
			if ($listId != '') {
				$response = AopsMailchimpIntegration::checkIfMailchimpListExists($listId);
				if ($response) {
					$newMailchimpListStatus = self::STATUS_OK;
				}
				else {
					$newMailchimpListStatus = self::STATUS_FAIL;
				}

				// clear options cache
				wp_cache_delete ( 'alloptions', 'options' );
			}
			else {
				$newMailchimpListStatus = self::STATUS_UNKNOWN;
			}

			// wordpress will use this later to save option into DB
			$_POST['aops_cu_mailchimp_default_extra_list_status'] = $newMailchimpListStatus;
		}
	}


	public static function requestMailchimpApi($requestUrl, $apiKey) {

		if (!$apiKey) {
			$apiKey = self::$apiKey;
		}

		if ($apiKey) {

			$dataCenter = "us1";

			if (strstr($apiKey, "-")){
				list($key, $dataCenter) = explode("-", $apiKey, 2);
				if (!$dataCenter) {
					$dataCenter = "us1";
				}
			}

			$mailchimpApiUrl = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/' . $requestUrl . '/';

			$curl = AopsCurlHelper::get_auth($mailchimpApiUrl, 'login', $apiKey, array());
			Aops::log(" requestMailchimpApi($requestUrl, $apiKey ) - result [$curl]");
			if ($curl) {
				$response = json_decode($curl);
				return $response;
			}
		}

		return false;

	}

	public static function postMailchimpApi($requestUrl, $apiKey, $postData) {

		if (!$apiKey) {
			$apiKey = self::$apiKey;
		}

		if ($apiKey) {

			$dataCenter = "us1";

			if (strstr($apiKey, "-")){
				list($key, $dataCenter) = explode("-", $apiKey, 2);
				if (!$dataCenter) {
					$dataCenter = "us1";
				}
			}

			$mailchimpApiUrl = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/' . $requestUrl . '/';
			self::log($mailchimpApiUrl );

			$curl = AopsCurlHelper::post_auth_json($mailchimpApiUrl, 'login', $apiKey, $postData);
			self::log($curl );

			if ($curl) {
				$response = json_decode($curl);
				self::log($response );
				return $response;
			}
		}

		return false;

	}


	/**
	 * Gets Mailchimp Lists
	 * http://kb.mailchimp.com/api/resources/lists/lists-collection
	 *
	 * @param string $listId
	 * @param string $apiKey
	 * @return array or false on fail
	 */
	public static function getMailchimpLists($apiKey = '') {

		$response = self::requestMailchimpApi('lists',$apiKey);

		if (is_object($response) && isset($response->lists) && is_array($response->lists)) {
			$lists = array();
			foreach ($response->lists as $list) {
				$lists[$list->id] = $list->name;
			}

			return $lists;
		}

		return false;
	}

	/**
	 * Checks if Mailchimp List is present
	 * http://kb.mailchimp.com/api/resources/lists/lists-collection
	 *
	 * @param string $listId
	 * @param string $apiKey
	 * @return array or false on fail
	 */
	public static function checkIfMailchimpListExists($listId, $apiKey = '') {

		$response = self::requestMailchimpApi('lists/' . $listId,$apiKey);

		if (is_object($response) && isset($response->name) && is_string($response->name)) {

			return $response->name;
		}

		return false;
	}

	/**
	 * Gets categories inside Mailchimp List  (in Mailchimp docs they call them Group Titles or Interest Categories)
	 * http://kb.mailchimp.com/api/resources/lists/interest-categories/lists-interest-categories-collection
	 *
	 * @param string $listId
	 * @param string $apiKey
	 * @return array or false on fail
	 */
	public static function getMailchimpGroupTitles($listId, $apiKey = '') {

		$requestUrl = 'lists/'.  $listId .'/interest-categories';
		$response = self::requestMailchimpApi($requestUrl,$apiKey);


		if (is_object($response) && isset($response->categories) && is_array($response->categories)) {
			$categories = array();
			foreach ($response->categories as $category) {
				$categories[$category->id] = $category->title;
			}
			return $categories;
		}

		return false;
	}

	/**
	 * Gets options inside Mailchimp Group Title (in Mailchimp docs they call them Groups or Interests)
	 * http://kb.mailchimp.com/api/resources/lists/interest-categories/interests/lists-interests-collection
	 *
	 * @param string $listId
	 * @param string $categoryId
	 * @param string $apiKey
	 * @return array or false on fail
	 */
	public static function getMailchimpGroups($listId, $categoryId, $apiKey = '') {

		$requestUrl = 'lists/'.  $listId .'/interest-categories/'. $categoryId . '/interests';

		$response = self::requestMailchimpApi($requestUrl,$apiKey);

		if (is_object($response) && isset($response->interests) && is_array($response->interests)) {
			$interests = array();
			foreach ($response->interests as $interest) {
				$interests[$interest->id] = $interest->name;
			}
			return $interests;
		}

		return false;
	}

	/**
	 * Adds a member into Mailchimp List
	 * http://kb.mailchimp.com/api/resources/lists/members/lists-members-collection
	 *
	 * @param string $listId
	 * @param array $subscriber
	 * @param string $apiKey
	 * @return array or false on fail
	 */
	public static function addMailchimpSubscriber($listId, $subscriber, $apiKey = '') {
		self::log("addMailchimpSubscriber");
		$response = self::postMailchimpApi('lists/' . $listId . '/members',$apiKey, $subscriber);
		self::log("self::postMailchimpApi $listId -- $apiKey ");
		self::log($response);

		if (is_object($response)) {
			return $response;
		}

		return false;
	}

	public static function processSubmission($cuID, $email, $name) {
		if (self::$options['mailchimp_status'] == self::STATUS_OK) {
			$meta = self::getMeta($cuID);
			$listId = false;

			self::log($meta );

			if (($meta['mailchimp_extra_list_id']) && ($meta['mailchimp_extra_list_status'] == self::STATUS_OK)) {
				self::log('$meta[mailchimp_extra_list_id] OK ');
				$listId = $meta['mailchimp_extra_list_id'];
			}
			elseif ($meta['mailchimp_list']) {
				self::log('$meta[mailchimp_list] OK ');
				$listId = $meta['mailchimp_list'];
			}

			if ($listId) {

				/*
				$subscriber = array(
					"email_address"		=> $email,
					"name"				=> $name,
					"email_type"		=> "",
					"status"			=> "subscribed",
					"merge_fields" => array(),
					"interests" => array(),
					"stats" => array(),
					"language" => "",
					"vip" => "",
					"location" => array(
						"latitude" => "",
						"longitude" => ""
					),
					"last_note" => array(
						"note_id" => "",
						"created_at" => "",
						"created_by" => "",
						"note" => ""
					)
				);
*/
				$interests = self::collectSubscriberInterests($meta, $listId);

/* subscriber SCHEME
{
	"email_type": "",
	"status": "",
	"status_if_new": "",
	"merge_fields": {},
	"interests": {},
	"stats": {},
	"language": "",
	"vip": "",
	"location": {
		"latitude": "",
		"longitude": ""
	}
}
*/

				$merge_fields = new stdClass();


				$name = explode(' ', $name, 2);

				$merge_fields->FNAME = $name[0];
				$merge_fields->LNAME = $name[1] ? $name[1] : "";

				$subscriber = array(
					"id"				=> md5($email),
					"email_address"		=> $email,
					"merge_fields"		=> $merge_fields,
					"email_type"			=> "text",
					"status"					=> "subscribed",
					"interests"				=> $interests
				);
				$subscriber = apply_filters( 'ao_content_upgrades_mailchimp_subscriber', $subscriber, $cuID );

				self::log($subscriber);
				self::addMailchimpSubscriber( $listId, $subscriber );
			}
		}
	}

	private static function collectSubscriberInterests($meta, $listId) {
		$interests = new stdClass();
		$listGroups = $meta['mailchimp_list_groups'];

		if (is_array($meta['mailchimp_groups'])) {
			foreach($meta['mailchimp_groups'] as $groupId => $groupTitles) {
				if (in_array($groupId, $listGroups[$listId])) {
					foreach ($groupTitles as $interestId => $selected) {
						if ($selected) $interests->$interestId = true;
					}
				}
			}
		}
		return $interests;
	}
}
?>
